<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\MyBusinessLodging;

class EnhancedCleaning extends \Google\Model
{
  /**
   * @var bool
   */
  public $commercialGradeDisinfectantCleaning;
  /**
   * @var string
   */
  public $commercialGradeDisinfectantCleaningException;
  /**
   * @var bool
   */
  public $commonAreasEnhancedCleaning;
  /**
   * @var string
   */
  public $commonAreasEnhancedCleaningException;
  /**
   * @var bool
   */
  public $employeesTrainedCleaningProcedures;
  /**
   * @var string
   */
  public $employeesTrainedCleaningProceduresException;
  /**
   * @var bool
   */
  public $employeesTrainedThoroughHandWashing;
  /**
   * @var string
   */
  public $employeesTrainedThoroughHandWashingException;
  /**
   * @var bool
   */
  public $employeesWearProtectiveEquipment;
  /**
   * @var string
   */
  public $employeesWearProtectiveEquipmentException;
  /**
   * @var bool
   */
  public $guestRoomsEnhancedCleaning;
  /**
   * @var string
   */
  public $guestRoomsEnhancedCleaningException;

  /**
   * @param bool
   */
  public function setCommercialGradeDisinfectantCleaning($commercialGradeDisinfectantCleaning)
  {
    $this->commercialGradeDisinfectantCleaning = $commercialGradeDisinfectantCleaning;
  }
  /**
   * @return bool
   */
  public function getCommercialGradeDisinfectantCleaning()
  {
    return $this->commercialGradeDisinfectantCleaning;
  }
  /**
   * @param string
   */
  public function setCommercialGradeDisinfectantCleaningException($commercialGradeDisinfectantCleaningException)
  {
    $this->commercialGradeDisinfectantCleaningException = $commercialGradeDisinfectantCleaningException;
  }
  /**
   * @return string
   */
  public function getCommercialGradeDisinfectantCleaningException()
  {
    return $this->commercialGradeDisinfectantCleaningException;
  }
  /**
   * @param bool
   */
  public function setCommonAreasEnhancedCleaning($commonAreasEnhancedCleaning)
  {
    $this->commonAreasEnhancedCleaning = $commonAreasEnhancedCleaning;
  }
  /**
   * @return bool
   */
  public function getCommonAreasEnhancedCleaning()
  {
    return $this->commonAreasEnhancedCleaning;
  }
  /**
   * @param string
   */
  public function setCommonAreasEnhancedCleaningException($commonAreasEnhancedCleaningException)
  {
    $this->commonAreasEnhancedCleaningException = $commonAreasEnhancedCleaningException;
  }
  /**
   * @return string
   */
  public function getCommonAreasEnhancedCleaningException()
  {
    return $this->commonAreasEnhancedCleaningException;
  }
  /**
   * @param bool
   */
  public function setEmployeesTrainedCleaningProcedures($employeesTrainedCleaningProcedures)
  {
    $this->employeesTrainedCleaningProcedures = $employeesTrainedCleaningProcedures;
  }
  /**
   * @return bool
   */
  public function getEmployeesTrainedCleaningProcedures()
  {
    return $this->employeesTrainedCleaningProcedures;
  }
  /**
   * @param string
   */
  public function setEmployeesTrainedCleaningProceduresException($employeesTrainedCleaningProceduresException)
  {
    $this->employeesTrainedCleaningProceduresException = $employeesTrainedCleaningProceduresException;
  }
  /**
   * @return string
   */
  public function getEmployeesTrainedCleaningProceduresException()
  {
    return $this->employeesTrainedCleaningProceduresException;
  }
  /**
   * @param bool
   */
  public function setEmployeesTrainedThoroughHandWashing($employeesTrainedThoroughHandWashing)
  {
    $this->employeesTrainedThoroughHandWashing = $employeesTrainedThoroughHandWashing;
  }
  /**
   * @return bool
   */
  public function getEmployeesTrainedThoroughHandWashing()
  {
    return $this->employeesTrainedThoroughHandWashing;
  }
  /**
   * @param string
   */
  public function setEmployeesTrainedThoroughHandWashingException($employeesTrainedThoroughHandWashingException)
  {
    $this->employeesTrainedThoroughHandWashingException = $employeesTrainedThoroughHandWashingException;
  }
  /**
   * @return string
   */
  public function getEmployeesTrainedThoroughHandWashingException()
  {
    return $this->employeesTrainedThoroughHandWashingException;
  }
  /**
   * @param bool
   */
  public function setEmployeesWearProtectiveEquipment($employeesWearProtectiveEquipment)
  {
    $this->employeesWearProtectiveEquipment = $employeesWearProtectiveEquipment;
  }
  /**
   * @return bool
   */
  public function getEmployeesWearProtectiveEquipment()
  {
    return $this->employeesWearProtectiveEquipment;
  }
  /**
   * @param string
   */
  public function setEmployeesWearProtectiveEquipmentException($employeesWearProtectiveEquipmentException)
  {
    $this->employeesWearProtectiveEquipmentException = $employeesWearProtectiveEquipmentException;
  }
  /**
   * @return string
   */
  public function getEmployeesWearProtectiveEquipmentException()
  {
    return $this->employeesWearProtectiveEquipmentException;
  }
  /**
   * @param bool
   */
  public function setGuestRoomsEnhancedCleaning($guestRoomsEnhancedCleaning)
  {
    $this->guestRoomsEnhancedCleaning = $guestRoomsEnhancedCleaning;
  }
  /**
   * @return bool
   */
  public function getGuestRoomsEnhancedCleaning()
  {
    return $this->guestRoomsEnhancedCleaning;
  }
  /**
   * @param string
   */
  public function setGuestRoomsEnhancedCleaningException($guestRoomsEnhancedCleaningException)
  {
    $this->guestRoomsEnhancedCleaningException = $guestRoomsEnhancedCleaningException;
  }
  /**
   * @return string
   */
  public function getGuestRoomsEnhancedCleaningException()
  {
    return $this->guestRoomsEnhancedCleaningException;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(EnhancedCleaning::class, 'Google_Service_MyBusinessLodging_EnhancedCleaning');
